/*
 * Decompiled with CFR 0.152.
 */
package org.massreg.launch;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;

public class SecureProxy {
    static final int BUFFER_SIZE = 4096;

    public static void main(String[] args) throws IOException {
        try {
            System.out.println("Starting MASSREG secure proxy..");
            System.out.println("Don't close this window while working on MASSREG QGIS Plugin");
            System.out.println("If this windows remains open after QGIS is closed, please close it manually");
            String sessionID = args[0];
            String server = args[1];
            int port = 3011;
            ServerSocket listenSocket = new ServerSocket(5433);
            while (true) {
                Socket incommingSocket = listenSocket.accept();
                System.out.println("Accepted connection from pg client");
                new Thread(new ClientRunnable(incommingSocket, sessionID, server, port)).start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    static class ClientRunnable
    implements Runnable {
        Socket clientSocket;
        Socket serverSocket;
        String sessionID;
        String serverHost;
        int port;
        public int status = 0;

        public ClientRunnable(Socket clientSocket, String sessionID, String server, int port) {
            this.sessionID = sessionID;
            this.clientSocket = clientSocket;
            this.serverHost = server;
            this.port = port;
        }

        @Override
        public void run() {
            try {
                final byte[] buf = new byte[4096];
                final OutputStream clientOstr = this.clientSocket.getOutputStream();
                this.serverSocket = new Socket(this.serverHost, this.port);
                final ObjectOutputStream serverOstr = new ObjectOutputStream(this.serverSocket.getOutputStream());
                final ObjectInputStream serverInstr = new ObjectInputStream(this.serverSocket.getInputStream());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ++status;
                        try {
                            InputStream clientInstr = clientSocket.getInputStream();
                            while (true) {
                                int read;
                                if ((read = clientInstr.read(buf)) == -1) {
                                    System.out.println("Emtpy data received. Cosing input stream");
                                    clientInstr.close();
                                    clientInstr = clientSocket.getInputStream();
                                    continue;
                                }
                                Payload pl = new Payload();
                                pl.sessionID = sessionID;
                                pl.data = new byte[read];
                                System.arraycopy(buf, 0, pl.data, 0, read);
                                serverOstr.writeObject(pl);
                                Object var3_4 = null;
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("pg client read loop terminated with error");
                            ex.printStackTrace();
                            --status;
                            return;
                        }
                    }
                }).start();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ++status;
                        try {
                            while (true) {
                                Return ret = (Return)serverInstr.readObject();
                                if (ret.error != null && ret.error.length() > 0) {
                                    throw new Exception(ret.error);
                                }
                                clientOstr.write(ret.data);
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("pg client write loop terminated with error");
                            ex.printStackTrace();
                            --status;
                            return;
                        }
                    }
                }).start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class Return
    implements Serializable {
        public String error;
        public byte[] data;
    }

    public static class Payload
    implements Serializable {
        public String sessionID;
        public byte[] data;
    }
}

