# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MASSREG
                                 A QGIS plugin
 MASSREG Spatial data encoder
                              -------------------
        begin                : 2017-10-13
        git sha              : $Format:%H$
        copyright            : (C) 2017 by INTAPS Consultancy plc
        email                : info@intaps.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtWidgets import QAction, QToolButton,QWidget,QMessageBox
from PyQt5.QtGui import QIcon
# Initialize Qt resources from file resources.py
from . import resources
# Import the code for the dialog
from .massreg_encoder_dialog import MASSREGDialog
from .thematicmap_selector_dialog import TMAPDialog
import os.path
import json
import urllib

import requests
from PyQt5.QtGui import *
from qgis.core import *
from PyQt5.QtCore import QFileInfo
from PyQt5.QtCore import QTimer
from PyQt5.QtXml import QDomDocument
from qgis.core import QgsProject
from qgis.core import QgsDataSourceUri
from qgis.core import QgsVectorLayer

import traceback
import subprocess
import sys
import shutil
from . import airspeed
import threading
import time

class MASSREG:
    """QGIS Plugin Implementation."""
    sessionid=None
    kebeleList=None
    lockInfo=None
    skipEvent=False
    vlayer=None
    proc=None
    plugin_path=None
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_path=os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_path,
            'i18n',
            'MASSREG_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)


        # Declare instance attributes
        self.menu = self.tr(u'&MASSREG Spatial Encoder')



    def invokeServer(self,cmd,data):
        url="http://"+self.dlg.textServer.text()+":"+self.dlg.textPort.text()+cmd
        r=None
        if data is None:
            #self.showInformationMessage('get',str(url))
            r=requests.get(url,cookies={'JSESSIONID':self.sessionid})
        else:
            #self.showInformationMessage('post',str(url))
            r=requests.post(url,data=json.dumps(data),cookies={'JSESSIONID':self.sessionid})
        res=r.json()
        return res

    def showCriticalMessage(self,title,msg):
        w = QWidget()
        QMessageBox.critical(w, title,msg)
        w.show

    def showWarningMessage(self,msg):
        w = QWidget()
        QMessageBox.warning(w, 'MASSREG',msg)
        w.show

    def showUserConfirmation(self,msg):
        w = QWidget()
        reply=QMessageBox.question(self.dlg,'MASSREG',msg,QMessageBox.Yes,QMessageBox.No)
        return reply==QMessageBox.Yes
    def showInformationMessage(self,title,msg):
        w = QWidget()
        QMessageBox.information(w, title,msg)
        w.show

    def populateKebeles(self):
        self.skipEvent=True
        res=self.invokeServer('/api/setting?request=kebList',None)
        if res['error'] is None:
            self.kebeleList=res['res']
            self.dlg.comboKebele.clear()
            self.dlg.comboKebele.addItem('[No kebele locked]')
            for x in self.kebeleList:
                self.dlg.comboKebele.addItem(x['value']+'-'+x['key'])
        else:
            self.showCriticalMessage( 'Failed to retreive kebele list',res['error'])
        self.skipEvent=False

    def populateMapList(self):
        self.skipEvent=True
        res=self.invokeServer('/api/setting?request=tmapList',None)
        if res['error'] is None:
            self.mapList=res['res']
            self.dlgtmap.comboMap.clear()
            for x in self.mapList:
                self.dlgtmap.comboMap.addItem(x['value'])
        else:
            self.showCriticalMessage( 'Failed to retreive thematic map list',res['error'])
        self.skipEvent=False

    def monitorTMap(self,genID):
        self.gen_id=genID;
        self.dlgtmap.buttonGenerate.setEnabled(False)
        self.timer=QTimer()
        self.timer.timeout.connect(self.checkGen)
        self.timer.start(500)

    def getLegend(self):
        res=self.invokeServer('/api/tmap_status?cmd=getlegend&id='+self.gen_id,None)
        if res['error'] is None:
            return res['res']
        else:
            raise 'Erorr getting legend info from server\n'+res['error']

    def generateTMapSLD(self,legend):
            tpath=self.plugin_path+'\\velocity\\tmap.sld.v'
            with open(tpath, 'r') as myfile:
                template=myfile.read()

            r=airspeed.Template(template)
            sld=r.merge({'legend': legend})
            text_file = open(self.plugin_path+'\\tmap.sld', "w")
            text_file.write(sld)
            text_file.close()

    def addTMapLayer(self):
        legend=self.getLegend()

        layerName=legend['title']
        for l in QgsProject.instance().mapLayers().values():
            if l.name().find(layerName)==0:
                QgsProject.instance().removeMapLayer(l.id())
            else:
                self.iface.legendInterface().setLayerVisible(l,l.name()=='Kebele')
        uri=QgsDataSourceUri()
        uri.setConnection(self.dlg.textServer.text(),"5432","massreg","postgres","admin")
        uri.setDataSource("mapedit","tmap_data","geom","mapid=\'"+self.gen_id+"\'")
        tmaplayer=QgsVectorLayer(uri.uri(False),layerName,"postgres")
        self.generateTMapSLD(legend)
        style_path = os.path.dirname(__file__)+'/tmap.sld'

        tmaplayer.loadSldStyle(style_path)
        QgsProject.instance().addMapLayer(tmaplayer)
        self.iface.mapCanvas().setExtent(tmaplayer.extent())

        tfile=file(self.plugin_path+'\\tmap.qpt','rt')
        tfilecont=tfile.read()
        tfile.close()
        doc=QDomDocument()
        doc.setContent(tfilecont)
        comp=self.iface.createNewComposer()
        comp.composition().loadFromTemplate(doc)
        comp.composition().refreshItems()
    def checkGen(self):
        res=self.invokeServer('/api/tmap_status?id='+self.gen_id,None)
        if res['error'] is None:
            status=res['res']
            if status['status']==3 or status['status']==4: #done ok or error
                self.timer.stop()
                self.dlgtmap.buttonGenerate.setEnabled(True)
                if status['status']==4:
                    self.showCriticalMessage('Error generating map',status['status_message'])
                else:
                    self.addTMapLayer()
                self.dlgtmap.hide()
            else:
                self.dlgtmap.progressBar.setValue(status['progress']*100)
        else:
            self.dlgtmap.hide()
            self.timer.stop()
            self.dlgtmap.buttonGenerate.setEnabled(True)
            self.showCriticalMessage('Failed to lock kebele',res['error'])
            return False;

    def startGenClick(self):
        mapname=self.mapList[self.dlgtmap.comboMap.currentIndex()]['key']
        print('generating '+mapname)
        self.startTMAPGen(mapname)

    def startTMAPGen(self,mapname):
        res=self.invokeServer('/api/tmap_status?map='+mapname,{})
        if res['error'] is None:
            self.monitorTMap(res['res'])
            return True;
        else:
            self.showCriticalMessage('Failed to lock kebele',res['error'])
            return False;


    def parcel_geom_changed(self,fid,g):
        if self.skipEvent:
            return
        self.skipEvent=True
        self.vlayer.changeAttributeValue(fid,1,self.lockInfo['lockid'])
        self.vlayer.changeAttributeValue(fid,2,9876)
        self.skipEvent=False

    def parcel_changed(self,fid,idx,val):
        if self.skipEvent:
            return
        self.skipEvent=True
        self.vlayer.changeAttributeValue(fid,1,self.lockInfo['lockid'])
        self.vlayer.changeAttributeValue(fid,2,9876)
        self.skipEvent=False

    def parceld_added(self,fid):
        if self.skipEvent:
            return
        self.skipEvent=True
        self.vlayer.changeAttributeValue(fid,1,self.lockInfo['lockid'])
        self.vlayer.changeAttributeValue(fid,2,9876)
        self.skipEvent=False

    def loadLayer(self,name,style,uri,schema,table,field,filter,key):
        uri.setDataSource(schema,table,field,filter,key)
        layer=QgsVectorLayer(uri.uri(False),name,"postgres")
        if  style:
            style_path = os.path.dirname(__file__)+'/'+style
            layer.loadNamedStyle(style_path)
        QgsProject.instance().addMapLayer(layer)
        print("added"+str(layer))
        self.map_layers.append(layer)
        return layer;
    
    def unloadMassregLayers(self):
        for l in self.map_layers:
             QgsProject.instance().removeMapLayer(l)
        self.map_layers=[]

    def loadLayers(self):
        if self.lockInfo is None:
            return;

        layerName="Kebele:"+self.lockInfo['kebelecode']
        for l in QgsProject.instance().mapLayers().values():
            if l.name()==layerName:
                QgsProject.instance().removeMapLayer(l.id())
                break
        uri=QgsDataSourceUri()
        uri.setConnection(self.dlg.textServer.text(),"5432","massreg","postgres","admin")
        
        #uri.setDataSource("mapedit","parcelgeometry","geom","lockid=\'"+self.lockInfo['lockid']+"\'")
        #self.vlayer=QgsVectorLayer(uri.uri(False),layerName,"postgres")
        #style_path = os.path.dirname(__file__)+'/edit_parcel.qml'
        #self.vlayer.loadNamedStyle(style_path)
        print("adding layers")
        self.vlayer=self.loadLayer(layerName,'edit_parcel.qml',uri,"mapedit","parcelgeometry","geom","lockid=\'"+self.lockInfo['lockid']+"\'","id")
        self.vlayer.attributeValueChanged.connect(self.parcel_changed)
        self.vlayer.geometryChanged.connect(self.parcel_geom_changed)
        self.vlayer.featureAdded.connect(self.parceld_added)

        self.kebele_layer=self.loadLayer("Kebele Boundary",'kebele.qml',uri,"public","kebele","geom","","id")
        self.parcel_layer=self.loadLayer("All Parcels",'allparcel.qml',uri,"public","parcelgeometry","geom","","id")
        self.kebele_layer.setReadOnly(True)
        self.parcel_layer.setReadOnly(True)
    def hasChanges(self):
        l=self.getLock()
        if l is None:
            return 0
        if l['haschanges']:
            return 2
        else:
            return 1

    def getLock(self):
        res=self.invokeServer('/api/maplock',None)
        if res['error'] is None:
            return res['res']
        else:
             raise Exception('Failed to get lock information',res['error'])
    def loadLock(self):
        res=self.invokeServer('/api/maplock',None)
        if res['error'] is None:
            self.lockInfo=res['res']
            if self.lockInfo is not None:
                i=0
                for x in self.kebeleList:
                    if x['key']==self.lockInfo['kebelecode']:
                        self.skipEvent=True
                        self.dlg.comboKebele.setCurrentIndex(i+1)
                        self.skipEvent=False
                        break
                    i=i+1
            self.loadLayers()
        else:
             self.showCriticalMessage('Failed to get lock information',res['error'])

    def lockKebele(self,kebeleCode):
        res=self.invokeServer('/api/maplock?cmd=lock&k='+kebeleCode,{'x':'x'})
        if res['error'] is None:
            self.lockInfo=res['res']
            self.loadLayers()
            return True;
        else:
            self.showCriticalMessage('Failed to lock kebele',res['error'])
            return False;

    def setFormMode(self,connectedMode):
        if connectedMode:
            self.dlg.textServer.setEnabled(False)
            self.dlg.textUserName.setEnabled(False)
            self.dlg.textPassword.setEnabled(False)
            self.dlg.buttonConnect.setEnabled(False)
            self.dlg.buttonDisconnect.setEnabled(True)
            self.dlg.comboKebele.setEnabled(True)
            self.dlg.buttonDiscard.setEnabled(True)
            self.dlg.buttonSave.setEnabled(True)
        else:
            self.dlg.textServer.setEnabled(True)
            self.dlg.textUserName.setEnabled(True)
            self.dlg.textPassword.setEnabled(True)
            self.dlg.buttonConnect.setEnabled(True)
            self.dlg.buttonDisconnect.setEnabled(False)
            self.dlg.comboKebele.setEnabled(False)
            self.dlg.buttonDiscard.setEnabled(False)
            self.dlg.buttonSave.setEnabled(False)

    def updateError(self):
        res=self.invokeServer('/api/maplock?cmd=errors',{})
        return res['res']['errorsCount']

    def syncComboBox(self):
        self.skipEvent=True
        if self.lockInfo is None:
            self.dlg.comboKebele.setCurrentIndex(0)
        else:
            i=0
            for x in self.kebeleList:
                if x['key']==self.lockInfo['kebelecode']:
                    self.skipEvent=True
                    self.dlg.comboKebele.setCurrentIndex(i+1)
                    self.skipEvent=False
                    break
                i=i+1
        self.skipEvent=False

    def comboKebele_indexChanged(self,index):
        if self.skipEvent:
            return;
        change=self.hasChanges()
        if change==2:
            self.showWarningMessage('Please discard or upload your changes first');
            self.syncComboBox()
            return;
        else:
            if change==1:
                self.discard_edit()
        try:
            if index==0:
                if self.lockInfo is not None:
                    self.discard_edit()
            else:
                self.lockKebele(self.kebeleList[index-1]['key'])
                self.syncComboBox()
        except Exception as ex:
            self.showCriticalMessage('Failed to lock kebele',str(ex))

    def detachFromLayer(self):
        self.unloadMassregLayers()
        self.vlayer=None
        self.lockInfo=None
        self.skipEvent=True
        self.dlg.comboKebele.setCurrentIndex(0);
        self.skipEvent=False

    def discard_edit(self):
        if self.hasChanges()==2:
            reply=self.showUserConfirmation('You have changes that are not uploaded to the server. Do you want to discard it?')
            if not reply:
                return;
        if  self.lockInfo is None:
            self.showCriticalMessage('Error','There is no active lock')
            return
        res=self.invokeServer('/api/maplock?cmd=unlock',{})
        self.detachFromLayer()

    def save_edit(self):
        try:
            if  self.lockInfo is None:
                self.showCriticalMessage('Error','There is no active lock')
                return
            if self.updateError()>0:
                self.showCriticalMessage('MASSREG','Your work has errors it can''t be uploaded to the server')
                self.vlayer.dataProvider().forceReload()
                self.vlayer.triggerRepaint()
                return;
            res=self.invokeServer('/api/maplock?cmd=commit',{})
            if res['error'] is not None:
                self.showCriticalMessage('Failed to upload data to server',res['error'])
                return

            self.detachFromLayer()

        except Exception as ex:
            self.showCriticalMessage('Failed to upload data to server',str(ex))

    def launch_proxy(self,server,sid):
		#setup proxy
        jar_path=self.plugin_path+'/SecureProxy.jar'
        print('Starting proxy')
        java_path=open(self.plugin_path+'/java_path.txt', 'r').read().strip();
        print('java path:'+java_path)
		#os.chdir(java_path)
		#startupinfo = subprocess.STARTUPINFO()
		#startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
        print(java_path+' -jar '+jar_path+' '+sid+' '+server)
		#self.proc=subprocess.Popen([java_path, '-jar',jar_path,self.sessionid,self.dlg.textServer.text()],startupinfo=None)
        os.system(java_path+ ' -jar '+ jar_path+' '+sid+' '+server)

    def connect_to_server(self):
        try:

            url="http://"+self.dlg.textServer.text()+":"+self.dlg.textPort.text()+"/api/login?"+urllib.parse.urlencode({'username':self.dlg.textUserName.text(),'password':self.dlg.textPassword.text()})
            r=requests.post(url)
            res=r.json()

            if res['error'] is None:
                self.sessionid=r.cookies['JSESSIONID']
                print(self.sessionid)
                #t=threading.Thread(target=self.launch_proxy,args=(self.dlg.textServer.text(),self.sessionid))
                #t.start()
                #time.sleep(5)
                self.populateKebeles()
                self.populateMapList()
                self.setFormMode(True)

                
                self.map_layers=[]

                self.loadLock()
                self.actionTMap.setEnabled(True)
                self.dlg.hide()
            else:
                w = QWidget()
                QMessageBox.critical(w, 'Login failed',res['error'])
                w.show()
        except Exception as ex:
            w = QWidget()
            QMessageBox.critical(w, 'Login failed',traceback.format_exc())
            w.show()

    def shutDownProxy(self):
        print('killing process')
        #if (self.proc is not None) and (self.proc.poll() is None):
        #    self.proc.kill()
        #    print 'process kill command sent'
        #else:
        #    print 'process not running'

    
    def disconnect(self):
        try:
            self.shutDownProxy()

            res=self.invokeServer("/api/login?logout=true",{})
            self.detachFromLayer()            
            self.setFormMode(False)
            if res['error'] is not None:
                w = QWidget()
                QMessageBox.critical(w, 'Logout error',res['error'])
                w.show()
            else:
                self.actionTMap.setEnabled(False)
        except Exception as ex:
            w = QWidget()
            QMessageBox.critical(w, 'Logout error',traceback.format_exc())
            w.show()


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MASSREG', message)


    def testAirSpeed(self):
        """ Test Air Speed Module """
        t = airspeed.Template("""
        Old people:
        #foreach ($person in $people)
         #if($person.age > 70)
          $person.name
         #end
        #end

        Third person is $people[2].name
        """)
        people = [{'name': 'Bill', 'age': 100}, {'name': 'Bob', 'age': 90}, {'name': 'Mark', 'age': 25}]
        print(t.merge(locals()))

    def runTMAPDilaog(self):
        self.dlgtmap.show()
        result = self.dlgtmap.exec_()


    def add_action(self):

        # Create the dialog (after translation) and keep reference
        self.dlg = MASSREGDialog()
        self.dlg.buttonConnect.clicked.connect(self.connect_to_server)
        self.dlg.buttonDisconnect.clicked.connect(self.disconnect)
        self.dlg.buttonDiscard.clicked.connect(self.discard_edit)
        self.dlg.buttonSave.clicked.connect(self.save_edit)
        self.dlg.comboKebele.currentIndexChanged.connect(self.comboKebele_indexChanged)
        self.setFormMode(False)

        # Create tmp dialog
        self.dlgtmap = TMAPDialog()
        self.dlgtmap.buttonGenerate.clicked.connect(self.startGenClick)
        self.dlgtmap.progressBar.setValue(0)

        #main massreg toolbar button
        icon_path = self.plugin_path+ '/icon.png'
        icon = QIcon(icon_path)
        action = QAction(icon, 'MASSREG Encoder', self.iface.mainWindow())
        action.triggered.connect(self.run)
        action.setEnabled(True)
        action.setStatusTip('MASSREG Encoder')
        self.iface.addPluginToMenu(self.menu,action)

        self.toolButton = QToolButton()
        self.toolButton.setDefaultAction( action)
        self.toolbarAction=self.iface.addToolBarWidget( self.toolButton )

        self.actionEncoder=action

        icon_path = self.plugin_path+ '/tmap.png'
        icon = QIcon(icon_path)
        action = QAction(icon, 'MASSREG Thematic Maps', self.iface.mainWindow())
        action.triggered.connect(self.runTMAPDilaog)
        action.setEnabled(False)
        action.setStatusTip('MASSREG Thematic Maps')
        self.iface.addPluginToMenu(self.menu,action)

        self.toolButtonTMap = QToolButton()
        self.toolButtonTMap.setDefaultAction( action)
        self.toolbarActionTMap=self.iface.addToolBarWidget( self.toolButtonTMap )

        self.actionTMap=action


    def login(self):
        self.showInformationMessage('MASSREG','login')

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        self.add_action()



    def unload(self):
        self.shutDownProxy()
        """Removes the plugin menu item and icon from QGIS GUI."""
        self.iface.removePluginMenu(self.tr(self.menu),self.actionEncoder)
        self.iface.removePluginMenu(self.tr(self.menu),self.actionTMap)
        self.iface.removeToolBarIcon(self.toolbarAction)
        self.iface.removeToolBarIcon(self.toolbarActionTMap)
        # remove the toolbar
        del self.toolButton
        del self.toolButtonTMap


    def run(self):
        """Run method that performs all the real work"""
        # show the dialog

        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
